<?php
use yii\helpers\Url;

return [
    [
        'class' => 'kartik\grid\CheckboxColumn',
        'width' => '20px',
    ],
    /*[
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],*/
        // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'id',
    // ],
    /*[
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'ip',
    ],*/
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'ipint',
        'value' => function($model){
            return long2ip($model->ipint);
        }
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'ipintto',
        'value' => function($model){
            return long2ip($model->ipintto);
        }
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'destination',
        'contentOptions' => ['class' => 'text-left', 'style' => 'width:30px;'],
        'value' => function ($model) {
            if($model->destination == 0){
                return 'network';
            } elseif($model->destination == 1){
                return 'honeypot';
            } elseif($model->destination == 2){
                return 'test';
            }
        },
        'filterType' => \kartik\grid\GridView::FILTER_SELECT2,
        'filter' => [
            0 => 'network',
            1 => 'honeypot',
            2 => 'test',
            
        ],
    ],
    [
        'class'=>'\kartik\grid\EditableColumn',
        'attribute'=>'comment',
        'contentOptions' => [ 'style' => 'width: 20%;' ],
        'value' => function($model){
            if(isset($model->comment)){
                return $model->comment;
            }else{
                return ' ';
            }
        },
        'editableOptions' => [
            'header' => '',
            'asPopover' => false,
            'inputType' => kartik\editable\Editable::INPUT_TEXTAREA,
            'options' => [
                'pluginOptions' => [

                ]
            ]
        ],
    
    ],[
        'class' => 'kartik\grid\ActionColumn',
        'dropdown' => false,
        'vAlign'=>'middle',
        'template' => '{update} {delete}',
        'urlCreator' => function($action, $model, $key, $index) { 
                return Url::to([$action,'id'=>$key]);
        },
        'viewOptions'=>['role'=>'modal-remote','title'=>'View','data-toggle'=>'tooltip'],
        'updateOptions'=>['role'=>'modal-remote','title'=>'Update', 'data-toggle'=>'tooltip'],
        'deleteOptions'=>['role'=>'modal-remote','title'=>'Delete', 
                          'data-confirm'=>false, 'data-method'=>false,// for overide yii data api
                          'data-request-method'=>'post',
                          'data-toggle'=>'tooltip',
                          'data-confirm-title'=>'Are you sure?',
                          'data-confirm-message'=>'Are you sure want to delete this item'], 
    ],

];   